% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_annotations.R
\name{build_lncrna_annots}
\alias{build_lncrna_annots}
\title{A helper function to build lncRNA annotations.}
\usage{
build_lncrna_annots(genome = c("hg19", "hg38", "mm10"))
}
\arguments{
\item{genome}{The genome assembly.}
}
\value{
A \code{GRanges} object with \code{id} giving the \code{transcript_type} from the GENCODE file, \code{tx_id} being the Ensembl transcript ID, \code{gene_id} being the Entrez ID coming from a mapping of gene symbol to Entrez ID, \code{symbol} being the gene_name from the GENCODE file, and the \code{type} being \code{[genome]_lncrna_gencode}.
}
\description{
Using the \code{AnnotationHub} package, retrieve transcript level lncRNA annotations for either human (GRCh38) or mouse (GRCm38). If the genome is 'hg19', use the permalink from GENCODE and \code{rtracklayer::import()} to download and process.
}
