% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGO.R
\name{getGO}
\alias{getGO}
\title{Assigns IC signatures to Gene Ontologies}
\usage{
getGO(
  cica,
  alpha = 0.05,
  genenames = NULL,
  genome = "org.Hs.eg.db",
  db = c("BP", "CC", "MF"),
  ncores = 4,
  rotate = TRUE
)
}
\arguments{
\item{cica}{list compliant to `consICA()` result}

\item{alpha}{value in [0,1] interval. Used to filter features with 
FDR < `alpha`. Default value is 0.05}

\item{genenames}{alternative names of genes. If NULL we use rownames of `S`
matrix. We automatically identify type of gene identifier, you can use  
Ensembl, Symbol, Entrez, Alias, Genename IDs.}

\item{genome}{R-package for genome annotation used. For human -
'org.Hs.eg.db'}

\item{db}{name of GO database: "BP","MF","CC"}

\item{ncores}{number of cores for parallel calculation. Default 
value is 4}

\item{rotate}{rotate components in `S` and `M` matricies in `cica` object 
to set most significant Gene Ontologies as positive effective features. 
Default is TRUE}
}
\value{
rotated (if need) `cica` object with added `GO` - 
list for each db chosen (BP, CC, MM), 
with dataframes `pos` for 
positive and `neg` for negative affecting features for each component:
    \item{GO.ID}{id of Gene Ontology term}
    \item{Term}{name of term}
    \item{Annotated}{number of annotated genes}
    \item{Significant}{number of significant genes}
    \item{Expected}{estimate of the number of annotated genes if the 
    significant} 
    \item{genes would be randomly selected from the gene universe
    classisFisher}{F-test}
    \item{FDR}{false discovery rate value}
    \item{Score}{genes score}
}
\description{
Assigns extracted independent components to Gene Ontologies and
rotate independent components (`S` matrix) to set most significant 
Gene Ontologies as positive affecting features. Set `ncores` param for 
paralleled calculations.
}
\examples{
data("samples_data")
# Calculate ICA (run with ntry=1 for quick test, use more in real analysis)
#cica <- consICA(samples_data, ncomp=2, ntry=1, ncores=1, show.every=0) 
# cica <- consICA(samples_data, ncomp=40, ntry=20, show.every=0)

# Annotate independent components with gene ontoligies
# cica <- getGO(cica, db = "BP", ncores=4)
## Positively affected GOs for 2nd independent component
#head(cica$GO$GOBP$ic02$pos)
}
\author{
Petr V. Nazarov
}
