% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoImageList-utils.R
\docType{methods}
\name{CytoImageList-manipulation}
\alias{CytoImageList-manipulation}
\alias{scaleImages}
\alias{scaleImages,CytoImageList-method}
\alias{normalize}
\alias{normalize,CytoImageList-method}
\title{Manipulating CytoImageList objects}
\value{
A CytoImageList object containing the manipulated Images.
}
\description{
Methods to change pixel values in CytoImageList objects. In the
following sections, \code{object} is a \linkS4class{CytoImageList} object
containing one or multiple channels.
}
\section{Image scaling}{

In some cases, images need to be scaled by a constant
(e.g. 2^16-1 = 65535) \code{value} to revert them back to the original
pixel values after reading them in.
\describe{
\item{\code{scaleImages(object, value)}}{Scales all images in the
\linkS4class{CytoImageList} \code{object} by \code{value}. Here \code{value}
needs to be a single numeric or a numeric vector of the same length as
\code{object}.}
}
}

\section{Image normalization}{

Linear scaling of the intensity values of each \linkS4class{Image} contained
in a \linkS4class{CytoImageList} \code{object} to a specific range. Images
can either be scaled to the minimum/maximum value per channel or across all
channels (default \code{separateChannels = TRUE}). Also, images can be scaled
to the minimum/maximum value per image or across all images (default
\code{separateImages = FALSE}). The latter allows the visual comparison of
intensity values across images.

To clip the images before normalization, the \code{inputRange} can be set.
The \code{inputRange} either takes NULL (default), a vector of length 2
specifying the clipping range for all channels or a list where each
named entry contains a channel-specific clipping range.

Image normalization also works for images stored on disk. By default,
the normalized images are stored as a second entry called "XYZ_norm"
in the .h5 file. Here "XYZ" specifies the name of the original entry.
By storing the normalized next to the original images on disk, space
usage increases. To avoid storing duplicated data, one can specify
\code{overwrite = TRUE}, therefore deleting the original images
and only storing the normalized images. However, the original images
cannot be accessed anymore after normalisation.

\code{normalize(object, separateChannels = TRUE, separateImages = FALSE,
ft = c(0, 1), inputRange = NULL, overwrite = FALSE)}:

\describe{
\item{\code{object}:}{A CytoImageList object}
\item{\code{separateChannels}:}{Logical if pixel values should be normalized
per channel (default) or across all channels.}
\item{\code{separateImages}:}{Logical if pixel values should be normalized
per image or across all images (default).}
\item{\code{ft}:}{Numeric vector of 2 values, target minimum and maximum
intensity values after normalization (see \code{\link[EBImage]{normalize}}).}
\item{\code{inputRange}:}{Numeric vector of 2 values, sets the absolute
clipping range of the input intensity values (see
\code{\link[EBImage]{normalize}}). Alternatively a names list where each
entry corresponds to a channel-specific clipping range.}
\item{\code{overwrite}:}{Only relevant when images are kept on disk. By
specifying \code{overwrite = TRUE}, the normalized images will overwrite
the original images in the .h5 file, therefore reducing space on disk.
However, the original images cannot be accessed anymore after normalization.
If \code{overwrite = FALSE} (default), the normalized images are added as
a new entry called "XYZ_norm" to the .h5 file.})
}
}

\examples{
data(pancreasImages)

# Scale images to create segmentation masks
cur_files <- list.files(system.file("extdata", package = "cytomapper"),
                        pattern = "mask.tiff", full.names = TRUE)
x <- loadImages(cur_files)
# Error when running plotCells(x)
# Therefore scale to account for 16 bit encoding
x <- scaleImages(x, 2^16 - 1)
plotCells(x)

# Default normalization
x <- normalize(pancreasImages)
plotPixels(x, colour_by = c("H3", "CD99"))

# Setting the clipping range
x <- normalize(x, inputRange = c(0, 0.9))
plotPixels(x, colour_by = c("H3", "CD99"))

# Setting the clipping range per channel
x <- normalize(pancreasImages,
                inputRange = list(H3 = c(0, 70), CD99 = c(0, 100)))
plotPixels(x, colour_by = c("H3", "CD99"))

# Normalizing per image
x <- normalize(pancreasImages, separateImages = TRUE)
plotPixels(x, colour_by = c("H3", "CD99"))

}
\seealso{
\code{\link[EBImage]{normalize}} for details on Image normalization
}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
