% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoImageList-utils.R
\docType{methods}
\name{CytoImageList-naming}
\alias{CytoImageList-naming}
\alias{channelNames}
\alias{channelNames<-}
\alias{channelNames,CytoImageList-method}
\alias{channelNames<-,CytoImageList-method}
\alias{names,CytoImageList-method}
\alias{names<-,CytoImageList-method}
\title{Getting and setting the channel and image names}
\description{
Methods to get and set the names of individual channels or the names of
individual images.
}
\section{Setting and getting the channel names}{

In the following code, \code{x} is a \linkS4class{CytoImageList}
object containing one or multiple channels. The channel
names can be replaced by \code{value}, which contains a character vector of
the same length as the number of channels in the images.
\describe{
\item{\code{channelNames(x)}}{Returns the names of all channels stored in
\code{x}}
\item{\code{channelNames(x) <- value}}{Replaces the channel names of
\code{x} with \code{values}. For this, \code{value} needs to have the same
length as the number of channels in \code{x}}
}
}

\section{Setting and getting the image names}{

Here, \code{x} is a \linkS4class{CytoImageList} object. The element
names can be replaced by \code{value}, which contains a character vector of
the same length as the number of images. In case of the CytoImageList object,
elements are always images.
\describe{
\item{\code{names(x)}}{Returns the names of all images stored in \code{x}}
\item{\code{names(x) <- value}}{Replaces the image names of
\code{x} with \code{value}. For this, \code{value} needs to have the same
length as \code{x}}
}
}

\examples{
data("pancreasImages")

# Get channel and image names
channelNames(pancreasImages)
names(pancreasImages)

# Set channel and image names
channelNames(pancreasImages) <- paste0("marker", 1:5)
names(pancreasImages) <- paste0("image", 1:3)

}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
