test_that("On disk: plotCells: Standard input testing works", {
  data("pancreasSCE")
  data("pancreasMasks")
  
  cur_path <- tempdir()
  on.exit(unlink(cur_path))
  
  cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  # Add test if only mask can be displayed
  expect_silent(plotCells(mask = cur_Masks))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb"))
})

test_that("On disk: plotCells: Features can be displayed.", {
  data("pancreasSCE")
  data("pancreasMasks")
  
  cur_path <- tempdir()
  on.exit(unlink(cur_path))
  
  cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "H3"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "PIN"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD8a"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CDH"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = c("H3", "CD99")))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = c("H3", "CD99", "PIN")))
  expect_silent(test1 <- plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb",
            colour_by = c("H3", "CD99", "PIN", "CD8a", "CDH"),
            return_plot = TRUE, display = "single"))
  expect_silent(test2 <- plotCells(object = pancreasSCE,
                          mask = rev(cur_Masks), img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = c("H3", "CD99", "PIN", "CD8a", "CDH"),
                          return_plot = TRUE, display = "single"))
  expect_identical(test1$plot$E34_imc, test2$plot$E34_imc)
  expect_identical(test1$plot$G01_imc, test2$plot$G01_imc)
  expect_identical(test1$plot$J02_imc, test2$plot$J02_imc)
})

test_that("On disk: plotCells: Metadata can be displayed.", {
  data("pancreasSCE")
  data("pancreasMasks")
    
  cur_path <- tempdir()
  on.exit(unlink(cur_path))
    
  cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CellType"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb",
            colour_by = "Area"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb",
            colour_by = "Pos_X"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb",
            colour_by = "Pos_Y"))

  # Test if cell id is factor
  pancreasSCE$CellNb2 <- factor(pancreasSCE$CellNb)
  expect_error(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb2", colour_by = "CellType"))

  # Test if image id is factor
  pancreasSCE$ImageNb2 <- factor(pancreasSCE$ImageNb)
  mcols(cur_Masks)$ImageNb2 <- factor(mcols(pancreasMasks)$ImageNb)
  expect_silent(plotCells(object = pancreasSCE,
                         mask = cur_Masks, img_id = "ImageNb2",
                         cell_id = "CellNb", colour_by = "CellType"))

  # Use factor entry
  pancreasSCE$CellType2 <- factor(pancreasSCE$CellType)
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "CellType2"))

  # Use logical entry
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "Pattern"))

})

test_that("On disk: plotCells: Cells can be outlined correctly.", {
  data("pancreasSCE")
  data("pancreasMasks")
    
  cur_path <- tempdir()
  on.exit(unlink(cur_path))
    
  cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb",
            outline_by = "CellType"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "CD99",
                          outline_by = "CellType"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD99",
            outline_by = "Area"))
})

test_that("On disk: plotCells: Exprs values can be correctly set.", {
  data("pancreasSCE")
  data("pancreasMasks")
    
  cur_path <- tempdir()
  on.exit(unlink(cur_path))
    
  cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", exprs_values = "counts",
            colour_by = "H3"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", exprs_values = "exprs",
            colour_by = "H3"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "exprs",
                          colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))

})

test_that("On disk: plotCells: images can be correctly subsetted.", {
    data("pancreasSCE")
    data("pancreasMasks")
    
    cur_path <- tempdir()
    on.exit(unlink(cur_path))
    
    cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_Masks[1], img_id = "ImageNb",
            cell_id = "CellNb", exprs_values = "counts",
            colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks[1:3], img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks[1:2], img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks[c(1,3)], img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks["E34_mask"], img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks[c("E34_mask", "J02_mask")], img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))

  cur_images <- cur_Masks["E34_mask"]
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_images, img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))

  cur_sce <- pancreasSCE[,pancreasSCE$ImageNb == 1]
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_images, img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))

  # Set image title
  cut_images <- getImages(cur_Masks, c("E34_mask", "J02_mask"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cut_images, img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99",
                          image_title = list(text = c("test1", "test2"))))

  # Use mcols entry
  mcols(cur_Masks)$MaskName <- paste0(names(cur_Masks), ".tiff")
  cur_images <- getImages(cur_Masks, mcols(cur_Masks)$MaskName %in% c("E34_mask.tiff", "J02_mask.tiff"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_images, img_id = "MaskName",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))
  cur_images <- getImages(cur_Masks, 1:2)
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_images, img_id = "MaskName",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "CD99"))

})

test_that("On disk: plotCells: colour can be correctly adjusted.", {
    data("pancreasSCE")
    data("pancreasMasks")
    
    cur_path <- tempdir()
    on.exit(unlink(cur_path))
    
    cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Works
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CD99",
                          colour = list(CD99 = colorRampPalette(c("black", "red"))(100))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CD99",
                          colour = list(CD99 = c("black", "red"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = c("H3", "CDH"),
                          colour = list(H3 = colorRampPalette(c("black", "red"))(100),
                                        CDH = colorRampPalette(c("black", "green"))(100))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CellType",
                          colour = list(CellType = c(celltype_B = "green",
                                                     celltype_A = "blue",
                                                     celltype_C = "red"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", exprs_values = "counts",
                          colour_by = "Area",
                          colour = list(Area = colorRampPalette(c("black", "red"))(100))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "Area",
                          colour = list(Area = c("black", "red"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "H3", outline_by = "CellType",
                          colour = list(CellType = c(celltype_B = "green",
                                                     celltype_A = "blue",
                                                     celltype_C = "red"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "H3", outline_by = "CellType",
                          colour = list(H3 = c("black", "green"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CellType", outline_by = "Area",
                          colour = list(CellType = c(celltype_B = "green",
                                                     celltype_A = "blue",
                                                     celltype_C = "red"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CellType", outline_by = "Area",
                          colour = list(CellType = c(celltype_B = "green",
                                                     celltype_A = "blue",
                                                     celltype_C = "red"),
                                        Area = c("black", "green"))))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CellType", outline_by = "Area",
                          colour = list(Area = c("black", "green"))))
})

test_that("On disk: plotCells: SCE can be subsetted.", {
    data("pancreasSCE")
    data("pancreasMasks")
    
    cur_path <- tempdir()
    on.exit(unlink(cur_path))
    
    cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Subset cells
  set.seed(12345)
  cur_sce <- pancreasSCE[,sample(1:ncol(pancreasSCE), 100)]

  expect_silent(plotCells(object = cur_sce,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CellType"))
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "Pattern"))
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "CellType",
                colour = list(CellType = c(celltype_B = "green",
                                           celltype_A = "blue",
                                           celltype_C = "red"))))
  expect_silent(plotCells(object = cur_sce,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "H3"))
  expect_silent(plotCells(object = cur_sce,
            mask = cur_Masks, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "H3",
            outline_by = "CellType"))

  cur_sce <- pancreasSCE[,pancreasSCE$ImageNb == 1]
  cur_sce <- cur_sce[,1:10]
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "CellType"))
  cur_images <- getImages(cur_Masks, mcols(cur_Masks)$ImageNb == unique(cur_sce$ImageNb))
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_images, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "CellType"))
  
  cur_sce <- pancreasSCE[,pancreasSCE$CellType == "celltype_A"]
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "CellType"))
  expect_silent(plotCells(object = cur_sce,
                          mask = cur_Masks, img_id = "ImageNb",
                          cell_id = "CellNb", colour_by = "PIN"))
})

test_that("On disk: plotCells: Size of images can be changed.", {
    data("pancreasSCE")
    data("pancreasMasks")
    
    cur_path <- tempdir()
    on.exit(unlink(cur_path))
    
    cur_Masks <- CytoImageList(pancreasMasks, on_disk = TRUE, h5FilesPath = cur_path)

  # Change size of images
  # Decreasing the size
  cur_images <- cur_Masks
  setImages(cur_images, "E34_mask") <- cur_images[[1]][1:50, 1:10,drop=FALSE]

  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_images, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CellType"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_images, img_id = "ImageNb",
                          cell_id = "CellNb",
                          colour_by = "CellType",
                          display = "single"))
  expect_silent(plotCells(object = pancreasSCE,
            mask = cur_images[1], img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CellType"))
  expect_silent(plotCells(object = pancreasSCE,
                          mask = cur_images[1], img_id = "ImageNb",
                          cell_id = "CellNb", outline_by = "CellType"))
})



