% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{createMultiEmapAsIgraph}
\alias{createMultiEmapAsIgraph}
\title{Create a complex enrichment map as an igraph}
\usage{
createMultiEmapAsIgraph(
  gostResultsList,
  queryList,
  showCategory,
  similarityCutOff
)
}
\arguments{
\item{gostResultsList}{a \code{list} of \code{data.frame} containing 
the enrichment results to be plot with different group identification.}

\item{queryList}{a \code{list} of \code{character} string 
representing the name of query retained for each enrichment results present 
in the \code{gostResultsList} parameter. The query should be present in its 
associated enrichment results.}

\item{showCategory}{a positive \code{integer} or a \code{vector} of 
\code{characters} representing terms.  If a \code{integer}, the first 
\code{n} terms will be displayed. If \code{NULL}, 
all terms will be displayed.}

\item{similarityCutOff}{a positive \code{numeric}, larger than zero and
small than 1 that represent the minimum similarity level between two 
nodes (terms) to be linked by an edge.}
}
\value{
a \code{igraph} object representing the enrichment map with 
different colors for each group of enrichment results.
}
\description{
The function creates a complex enrichment map, as an igraph, 
using functional enrichment results.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retain the results section
gostResults <- as.data.frame(parentalNapaVsDMSOEnrichment$result)

## Limit the results subsection of REACTOME and KEGG
## Kegg is replicated to show shared results between queries
gostResultsREAC <- gostResults[which(gostResults$source == "REAC"),]
gostResultsREAC <- gostResultsREAC[1:13, ]
gostResultsKEGG <- gostResults[which(gostResults$source == "KEGG"),]
gostResultsKEGG2 <- gostResultsKEGG[1:6,]

## Extract meta data information
queryList <- list("parental - REACTOME", "parental - KEGG - v1", 
    "parental - KEGG - v2")

## Create basic enrichment map using Wikipathways terms
igraph <- enrichViewNet:::createMultiEmapAsIgraph(
    gostResultsList=list(gostResultsREAC, gostResultsKEGG, 
            gostResultsKEGG2), 
    queryList=queryList, showCategory=30L, similarityCutOff=0.5)
    
}
\author{
Astrid Deschênes
}
\keyword{internal}
