% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{createNetworkForCytoscape}
\alias{createNetworkForCytoscape}
\title{Create network and load it into Cytoscape}
\usage{
createNetworkForCytoscape(nodeEdgeInfo, title, collection)
}
\arguments{
\item{nodeEdgeInfo}{a TODO}

\item{title}{a \code{character} string representing the name assigned to
the network.}

\item{collection}{a \code{character} string representing the collection
name assigned to the network.}
}
\value{
\code{TRUE}
}
\description{
Create network from gprofiler2 results and load it
into Cytoscape
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retained the GO Molecular Function results
results <- parentalNapaVsDMSOEnrichment$result[
        parentalNapaVsDMSOEnrichment$result$source == "GO:MF", ]

## Extract node and edge information
information <- enrichViewNet:::extractInformationWhenIntersection(
        gostResults=results)
    
## The creation of the network can only be done when Cytoscape
## is up and running
## A network using GO - Molecular Function enriched terms will be
## generated and loaded into Cytoscape
if (enrichViewNet:::isCytoscapeRunning()) {
    enrichViewNet:::createNetworkForCytoscape(nodeEdgeInfo=information, 
        title="Test", collection="New Collection")
}

}
\author{
Astrid Deschênes
}
\keyword{internal}
