% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_identifiers.R
\name{validate_identifiers}
\alias{validate_identifiers}
\title{Check that specified identifier values exist in the data.}
\usage{
validate_identifiers(
  df,
  identifiers = NULL,
  req_ids = NULL,
  exp_one_ids = NULL
)
}
\arguments{
\item{df}{data.table with \code{colnames}.}

\item{identifiers}{Named list of identifiers where the \code{names} are standardized identifier names.
If not passed, defaults to \code{get_env_identifiers()}.}

\item{req_ids}{Character vector of standardized identifier names required to pass identifier validation.}

\item{exp_one_ids}{Character vector of standardized identifiers names
where only one identifier value is expected.
If not passed, defaults to \code{get_expect_one_identifiers()}.}
}
\value{
Named list of identifiers modified to pass validation against the input data.
Errors with explanatory message if validation cannot pass with the given identifiers and data.
}
\description{
Check that specified identifier values exist in the data and error otherwise.
}
\details{
Note that this does NOT set the identifiers anywhere (i.e. environment or \code{SummarizedExperiment} object).
If identifiers do not validate, will throw error as side effect.
}
\examples{
validate_identifiers(
  S4Vectors::DataFrame("Barcode" = NA, "Duration" = NA, "Template" = NA, "clid" = NA), 
  req_ids = "barcode"
)

}
\keyword{identifiers}
