% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{today}
\alias{today}
\title{Today's Date at Package Load Time}
\format{
A character string (e.g., "20250624").
}
\usage{
today
}
\description{
This variable stores the current date (in "yyyymmdd" format) at the time the
package is loaded. It is useful for reproducible filenames (e.g., in
\code{saveViz()}), and is automatically set when the package is attached.
}
\examples{
# Print the date stored at package load
library(gVenn)
today

# Use it in a filename
paste0("venn_plot_", today, ".pdf")
}
\keyword{datasets}
