% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEntropy.R
\name{calculateEntropy}
\alias{calculateEntropy}
\title{Positional Entropy / Diversity Biological Sequences}
\usage{
calculateEntropy(
  input.sequences,
  max.length = NULL,
  method = c("shannon", "inv.simpson", "gini.simpson", "norm.entropy", "pielou", "hill0",
    "hill1", "hill2"),
  padding.symbol = "."
)
}
\arguments{
\item{input.sequences}{`character()`. Vector of CDR3 AA strings.}

\item{max.length}{`integer(1)`. Target length to align / pad to.
*Default* = `max(nchar(sequences))`.}

\item{method}{Either the name of a built-in metric  (`"shannon"`, 
`"inv.simpson"`, `"gini.simpson"`, `"norm.entropy"`, `"pielou"`, `"hill0"`, 
`"hill1"`, `"hill2"`) **or** a custom function as described above.}

\item{padding.symbol}{Symbol to use for padding at the end of sequences.}
}
\value{
Named `numeric()` vector of diversity scores,
        one value per position (Pos1 … Pos*L*).
}
\description{
Computes residue-wise diversity for a set of aligned (right-padded)
CDR3 amino-acid sequences using *any* supported diversity estimator
in **immApex**.  The following metrics are recognized:

* **Shannon entropy:**           \code{\link[=shannon_entropy]{shannon_entropy}}
* **Inverse Simpson:**           \code{\link[=inv_simpson]{inv_simpson}}
* **Gini–Simpson index:**        \code{\link[=gini_simpson]{gini_simpson}}
* **Normalized entropy:**        \code{\link[=norm_entropy]{norm_entropy}}
* **Pielou evenness:**           \code{\link[=pielou_evenness]{pielou_evenness}}
* * **Hill numbers** (orders 0, 1, 2): \code{\link[=hill_q]{hill_q(0)}}, 
\code{\link[=hill_q]{hill_q(1)}}, \code{\link[=hill_q]{hill_q(2)}}

You may also supply a **custom function** to `method`; it must take a
numeric vector of clone counts and return a single numeric value.
}
\examples{
seqs <- c("CASSLGQDTQYF", "CASSIRSSYNEQFF", "CASSTGELFF")
calculateEntropy (seqs, method = "shannon")
}
