% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIMGT.R
\name{getIMGT}
\alias{getIMGT}
\title{Get IMGT Sequences for Specific Loci}
\usage{
getIMGT(
  species = "human",
  chain = "TRB",
  sequence.type = "aa",
  frame = "inframe",
  region = "v",
  max.retries = 3,
  verbose = TRUE
)
}
\arguments{
\item{species}{One or two-word common designation of species.}

\item{chain}{Sequence chain to access, e.g., \strong{TRB} or \strong{IGH}.}

\item{sequence.type}{Type of sequence - \strong{aa} (amino acid) or \strong{nt} (nucleotide).}

\item{frame}{Designation for \strong{all}, \strong{inframe}, or \strong{inframe+gap}.}

\item{region}{Gene loci to access.}

\item{max.retries}{Number of attempts to fetch data in case of failure.}

\item{verbose}{Print messages corresponding to the processing step.}
}
\value{
A list of allele sequences.
}
\description{
Use this to access the ImMunoGeneTics (IMGT) sequences for a
specific species and gene loci. More information on 
IMGT can be found at \href{https://www.imgt.org/}{imgt.org}.
}
\examples{
\dontrun{
TRBV_aa <- getIMGT(species = "human",
                   chain = "TRB",
                   frame = "inframe",
                   region = "v",
                   sequence.type = "aa", 
                   max.retries = 3) 
}

}
