% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{hill_q}
\alias{hill_q}
\title{Hill-Number Generator}
\usage{
hill_q(q)
}
\arguments{
\item{q}{Numeric order of diversity.  Common values:
*0* (richness), *1* (exp(*H*)), *2* (inverse Simpson).}
}
\value{
A **closure**: `hill_q(q)` returns a function that takes a
  vector of counts and yields the corresponding ^qD.  The returned
  function is vectorised over its input.
}
\description{
Returns a *function* that computes the Hill diversity of order *q*
(also called the “effective number of species”):
}
\details{
\deqn{^{q}D \;=\;
   \left( \sum_{i} p_i^{\,q} \right)^{1/(1-q)}, \quad q \neq 1}

For *q = 1* the formula is undefined; the limit is
\deqn{^{1}D = e^{H'}}.
}
\section{References}{

Hill, M. O. (1973) *Diversity and Evenness: A Unifying Notation and its
Consequences.* Ecology **54** (2), 427–432.
}

\examples{
hill1 <- hill_q(1)   # q = 1
hill1(c(5, 1, 1, 1))

hill2 <- hill_q(2)   # q = 2, inverse-Simpson
hill2(c(5, 1, 1, 1))
}
