% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{inv_simpson}
\alias{inv_simpson}
\title{Inverse Simpson Diversity}
\usage{
inv_simpson(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
Numeric value >= 1.  Equals 1 when all observations belong to a
  single category.
}
\description{
Computes the inverse of Simpson’s concentration index, sometimes written
as *1/D*.  This metric emphasizes dominant categories.
}
\details{
\deqn{1/D \;=\; \frac{1}{\sum_{i} p_i^{\,2}}}
}
\examples{
inv_simpson(c(10, 5, 1))
}
