% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryMatrix.R
\name{summaryMatrix}
\alias{summaryMatrix}
\title{Fast Matrix Summaries}
\usage{
summaryMatrix(x, margin = 2, stats = "all", na.rm = TRUE)
}
\arguments{
\item{x}{Numeric matrix (will be coerced with \code{as.matrix()}).}

\item{margin}{Integer. 1 = operate row-wise; 2 = column-wise (default 2).}

\item{stats}{Character vector naming the statistics to return.  Any
combination of the following (case-insensitive):
 \itemize{
    \item \code{"min"} 
    \item \code{"max"}
    \item \code{"mean"} 
    \item \code{"median"}
    \item \code{"sd"} 
    \item \code{"var"}
    \item \code{"mad"} 
    \item \code{"sum"},
    \item \code{"iqr"}
    \item \code{"n"}
    \item \code{"na"}
    \item \code{"mode"}
    \item \code{"all"} 
   }}

\item{na.rm}{Logical; ignore \code{NA}s when calculating statistics
default \code{TRUE}).}
}
\value{
A numeric matrix with one **row per object that was summarised**
(rows of the input when \code{margin = 1}, otherwise columns) and one 
**column per requested statistic**. Row-names (if present) are preserved; 
column names are the statistic labels.
}
\description{
Computes a comprehensive panel of univariate statistics for every
**row** *or* **column** of a numeric matrix.  It is designed for
lightweight feature-engineering pipelines where many summaries are
required up-front (e.g. before modeling).
}
\examples{
m <- matrix(rnorm(20), 4, 5,
            dimnames = list(paste0("g", 1:4), paste0("s", 1:5)))

## Column-wise summaries (default)
head(summaryMatrix(m))

## Row-wise summaries
head(summaryMatrix(m, margin = 1))
}
