% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granges_manipulation.R
\name{createRandomRegions}
\alias{createRandomRegions}
\title{Create a GRanges with random regions from a genome}
\usage{
createRandomRegions(
  genome,
  n_regions = 1000,
  region_widths = 1000,
  sequence_names = NULL,
  all_sequence_names_equally_likely = FALSE,
  stranded = FALSE,
  masked_regions = NULL,
  allow_overlapping_regions = FALSE,
  ignore.strand = TRUE,
  max_tries = 100
)
}
\arguments{
\item{genome}{A BSgenome object.}

\item{n_regions}{Number of random regions to create. Default is 1000.}

\item{region_widths}{The widths of the random regions. Widths cannot be negative.
Can be just a single value if all regions are to have the same widths. Default is 1000.}

\item{stranded}{TRUE or FALSE indicating if created regions should have a strand randomly assigned. Default is FALSE, indicating to make unstranded regions.}

\item{masked_regions}{An optional GRanges object which random regions will not be allowed to overlap.}

\item{allow_overlapping_regions}{TRUE or FALSE indicating if created random regions should be allowed to overlap. Default is FALSE.}

\item{ignore.strand}{TRUE or FALSE indicating whether strand should be ignored when
identifying overlaps between random regions with each other or with masked_regions.
Only relevant if stranded is TRUE and either allow_overlapping_regions is FALSE or masked_regions is provided. Default is TRUE.}

\item{max_tries}{The maximum number of attempts to make to find non-overlapping regions which do not overlap masked_regions. Default value is 100.}

\item{sequences}{The names of sequences to create random regions on. Default is to use all sequences in the genome.}

\item{all_sequences_equally_likely}{TRUE or FALSE indicating if the probability of creating random regions on a sequence should be the same for each sequence.
Default is FALSE, indicating to make the probability proportional to a sequences length.}
}
\value{
A GRanges object
}
\description{
Can constrain the random regions so that they do not overlap each other and/or an optional set of masked regions.
Random regions which do meet these constraints will be discarded and new ones generated until the desired number
of regions has been reached or a maximum allowed number of attempts has been made.
After the maximum number of allowed attempts, the created random regions meeting the constraints up to that point will be returned.
Any random regions that are out-of-bounds relative to their sequence length are trimmed before being returned.
}
\examples{
# Set random seed
set.seed(123)

# Create 10,000 random non-overlapping regions with width 1,000 for hg38
random_regions <- methodical::createRandomRegions(genome = "BSgenome.Hsapiens.UCSC.hg38", n_regions = 10000)
head(random_regions)
}
