% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_regions.R
\name{.chunk_regions}
\alias{.chunk_regions}
\title{Split genomic regions into balanced chunks based on the number of methylation sites that they cover}
\usage{
.chunk_regions(
  meth_rse,
  genomic_regions,
  max_sites_per_chunk = NULL,
  ncores = 1
)
}
\arguments{
\item{meth_rse}{A RangedSummarizedExperiment with methylation values.}

\item{genomic_regions}{A GRanges object.}

\item{max_sites_per_chunk}{The maximum number of methylation sites to load into memory at once for each chunk.}

\item{ncores}{The number of cores that will be used.}
}
\value{
A GRangesList where each GRanges object overlaps approximately the number of methylation sites given by max_sites_per_chunk
}
\description{
Split genomic regions into balanced chunks based on the number of methylation sites that they cover
}
