% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kallisto_quantify.R
\name{kallistoQuantify}
\alias{kallistoQuantify}
\title{Run kallisto on a set of FASTQ files and merge the results}
\usage{
kallistoQuantify(
  path_to_kallisto,
  kallisto_index,
  forward_fastq_files,
  reverse_fastq_files,
  sample_names,
  output_directory,
  merged_output_prefix = "kallisto_transcript",
  messages_file = "",
  ncores = 1,
  number_bootstraps = 100
)
}
\arguments{
\item{path_to_kallisto}{Path to kallisto executable}

\item{kallisto_index}{Path to a kallisto index}

\item{forward_fastq_files}{A vector with the paths to forward FASTQ files. Each file should correspond to the file at the same position in reverse_fastq_files.}

\item{reverse_fastq_files}{A vector with the paths to reverse FASTQ files. Each file should correspond to the file at the same position in forward_fastq_files.}

\item{sample_names}{A vector with the names of samples for each pair of samples from forward_fastq_files and reverse_fastq_files}

\item{output_directory}{The name of the directory to save results in. Will be created if it doesn't exist.}

\item{merged_output_prefix}{Prefix to use for names of merged output files for counts and TPM which take the form
{merged_output_prefix}_counts_merged.tsv.gz and {merged_output_prefix}_tpm_merged.tsv.gz. Default prefix is "kallisto_transcript" i.e. default output merged output files are
kallisto_transcript_counts_merged.tsv.gz and kallisto_transcript_tpm_merged.tsv.gz.}

\item{messages_file}{Name of file to save kallisto run messages. If no file name given, information is printed to stdout.}

\item{ncores}{The number of cores to use. Default is 1.}

\item{number_bootstraps}{The number of bootstrap samples. Default is 100.}
}
\value{
The path to the merged counts table.
}
\description{
Run kallisto on a set of FASTQ files and merge the results
}
