% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_rse_functions.R
\name{liftoverMethRSE}
\alias{liftoverMethRSE}
\title{Liftover rowRanges of a RangedSummarizedExperiment for methylation data from one genome build to another}
\usage{
liftoverMethRSE(
  meth_rse,
  chain,
  remove_one_to_many_mapping = TRUE,
  permitted_target_regions = NULL,
  seqlevels = NULL
)
}
\arguments{
\item{meth_rse}{A RangedSummarizedExperiment for methylation data}

\item{chain}{A "Chain" object to be used with rtracklayer::liftOver}

\item{remove_one_to_many_mapping}{TRUE or FALSE indicating whether to remove regions in the source genome
which map to multiple regions in the target genome. Default is TRUE.}

\item{permitted_target_regions}{An optional GRanges object used to filter the rowRanges by overlaps after liftover,
for example CpG sites from the target genome. Any regions which do not overlap permitted_target_regions will be removed.
GRangesList to GRanges if all remaining source regions can be uniquely mapped to the target genome.}

\item{seqlevels}{An optional character vector giving the order to use for
seqlevels of the rowRanges of the returned RangedSummarizedExperiment.}
}
\value{
A RangedSummarizedExperiment with rowRanges lifted over to the genome build indicated by chain.
}
\description{
Removes methylation sites which cannot be mapped to the target genome build and those which result in
many-to-one mappings. Also removes one-to-many mappings by default and can remove sites which do not
map to allowed regions in the target genome e.g. CpG sites.
}
\examples{
# Load sample RangedSummarizedExperiment with CpG methylation data
data(tubb6_meth_rse, package = "methodical")
tubb6_meth_rse <- eval(tubb6_meth_rse)
  
# Get CpG sites for hg19
hg19_cpgs <- methodical::extractMethSitesFromGenome("BSgenome.Hsapiens.UCSC.hg19")

# Get liftover chain for mapping hg38 to hg19
library(AnnotationHub)
ah <- AnnotationHub()
chain <- ah[["AH14108"]]
  
# Liftover tubb6_meth_rse from hg38 to hg19, keeping only sites that were mapped to CpG sites in hg19
tubb6_meth_rse_hg19 <- methodical::liftoverMethRSE(tubb6_meth_rse, chain = chain, 
  permitted_target_regions = hg19_cpgs)
}
