% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_rse_functions.R
\name{maskRangesInRSE}
\alias{maskRangesInRSE}
\title{Mask regions in a ranged summarized experiment}
\usage{
maskRangesInRSE(rse, mask_ranges, assay_number = 1)
}
\arguments{
\item{rse}{A RangedSummarizedExperiment.}

\item{mask_ranges}{Either a GRanges with regions to be masked in all samples (e.g. repetitive sequences)
or a GRangesList object with different regions to mask in each sample (e.g. mutations). If using a GRangesList object, names of the list
elements should be the names of samples in rse.}

\item{assay_number}{Assay to perform masking. Default is first assay}
}
\value{
A RangedSummarizedExperiment with the regions present in mask_ranges masked
}
\description{
Mask regions in a ranged summarized experiment
}
\examples{
# Load sample RangedSummarizedExperiment with CpG methylation data
data(tubb6_meth_rse, package = "methodical")
tubb6_meth_rse <- eval(tubb6_meth_rse)

# Create a sample GRanges object to use to mask tubb6_meth_rse
mask_ranges <- GRanges("chr18:12305000-12310000")

# Mask regions in tubb6_meth_rse
tubb6_meth_rse_masked <- methodical::maskRangesInRSE(tubb6_meth_rse, mask_ranges)

# Count the number of NA values before and after masking
sum(is.na(assay(tubb6_meth_rse)))
sum(is.na(assay(tubb6_meth_rse_masked)))
}
