% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plotRegionValues}
\alias{plotRegionValues}
\title{Create a scatter plot with smoothed curve for values along adjacent loci in a genomic region}
\usage{
plotRegionValues(
  genomic_region_values,
  sample_name = NULL,
  reference_tss = FALSE,
  geom_point_params = list(),
  geom_smooth_params = list(),
  title = NULL,
  xlabel = NULL,
  ylabel = "Genomic Region Value",
  value_colours = c("#53868B", "#CD2626"),
  reverse_x_axis = FALSE
)
}
\arguments{
\item{genomic_region_values}{A data.frame with values associated with genomic regions.
Row names must be the coordinates of genomic regions in character format (e.g chr1:1000-2000) and
all regions must be located on the same sequence. The position of the first base in each region is used as the x-axis coordinate for the plot.}

\item{sample_name}{Name of column in genomic_region_values to plot. Defaults to first column if none provided.}

\item{reference_tss}{TRUE or FALSE indicating whether to show distances on the X-axis
relative to the TSS stored as an attribute \code{tss_range} of genomic_region_values.
Alternatively, can provide a GRanges object with a single range for such a TSS site.
In either case, will show the distance of genomic regions to the start of this region with genomic regions upstream
relative to the reference_tss shown first.
If FALSE (the default), the x-axis will instead show the start site coordinate of the genomic region.}

\item{geom_point_params}{An optional list to explicitly set values of parameters to use with geom_point(). Use list(alpha = 0) to make points invisible.}

\item{geom_smooth_params}{An optional list to explicitly set values of parameters to use with geom_smooth(). Use list(alpha = 0) to make line invisible.}

\item{title}{Title of the plot. Default is no title.}

\item{xlabel}{Label for the X axis in the plot. Defaults to "Distance to TSS" if reference_tss is used or
"seqname position" where seqname is the name of the relevant sequence.}

\item{ylabel}{Label for the Y axis in the plot. Default is "Genomic Region Value".}

\item{value_colours}{A vector with two colours to use, the first for low values and the second for high values. Defaults are c("#53868B", "#CD2626").}

\item{reverse_x_axis}{TRUE or FALSE indicating whether x-axis should be reversed,
for example if plotting a region on the reverse strand so that left side of plot corresponds to upstream.}
}
\value{
A ggplot object
}
\description{
Create a scatter plot with smoothed curve for values along adjacent loci in a genomic region
}
\examples{
# Load methylation-values around the TUBB6 TSS
data("tubb6_meth_rse", package = "methodical")
tubb6_meth_rse <- eval(tubb6_meth_rse)

# Extract methylation values from tubb6_meth_rse
tubb6_methylation_values = methodical::extractGRangesMethSiteValues(meth_rse = tubb6_meth_rse)

# Plot methylation values around TUBB6 TSS
methodical::plotRegionValues(tubb6_methylation_values, sample_name = "N1", ylabel = "Methylation Value")

# Create same plot but showing the distance to the TUBB6 TSS on the x-axis
data("tubb6_tss", package = "methodical")
methodical::plotRegionValues(tubb6_methylation_values, sample_name = "N1",
  reference_tss = tubb6_tss, ylabel = "Methylation Value")

}
