% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_region_methylation.R
\name{summarizeRegionMethylation}
\alias{summarizeRegionMethylation}
\title{Summarize methylation of genomic regions within samples}
\usage{
summarizeRegionMethylation(
  meth_rse,
  assay = 1,
  genomic_regions,
  genomic_region_names = NULL,
  col_summary_function = "colMeans2",
  keep_metadata_cols = FALSE,
  max_sites_per_chunk = floor(62500000/ncol(meth_rse)),
  na.rm = TRUE,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{meth_rse}{A RangedSummarizedExperiment with methylation values.}

\item{assay}{The assay from meth_rse to extract values from. Should be either an index or the name of an assay. Default is the first assay.}

\item{genomic_regions}{GRanges object with regions to summarize methylation values for.}

\item{genomic_region_names}{A character vector of unique names to assign genomic_regions in the output table.
Defaults to \code{names(genomic_regions)} if present or otherwise converts regions to character strings (e.g. "chr:1000-2000") to use as names.}

\item{col_summary_function}{A function that summarizes column values.
Should be the name of one of the column summary functions from MatrixGenerics. Default is "colMeans2".}

\item{keep_metadata_cols}{TRUE or FALSE indicating whether to add the metadata columns of genomic_regions to the output. Default is FALSE.}

\item{max_sites_per_chunk}{The approximate maximum number of methylation sites to try to load into memory at once.
The actual number loaded may vary depending on the number of methylation sites overlapping each region,
but so long as the size of any individual regions is not enormous (>= several MB), it should vary only very slightly.
Some experimentation may be needed to choose an optimal value as low values will result in increased running time,
while high values will result in a large memory footprint without much improvement in running time.
Default is floor(62500000/ncol(meth_rse)), resulting in each chunk requiring approximately 500 MB of RAM.}

\item{na.rm}{TRUE or FALSE indicating whether to remove NA values when calculating summaries. Default value is TRUE.}

\item{BPPARAM}{A BiocParallelParam object. Defaults to \code{BiocParallel::SerialParam()}.}

\item{...}{Additional arguments to be passed to col_summary_function.}
}
\value{
A data.table with the summary of methylation of each region in genomic_regions for each sample.
}
\description{
Summarize methylation of genomic regions within samples
}
\examples{

# Load sample RangedSummarizedExperiment with CpG methylation data
data(tubb6_meth_rse, package = "methodical")
tubb6_meth_rse <- eval(tubb6_meth_rse)

# Create a sample GRanges
test_gr <- GRanges(c("chr18:12303400-12303500", "chr18:12303600-12303750", "chr18:12304000-12306000"))
names(test_gr) <- paste("region", 1:3, sep = "_")

# Calculate mean methylation values for regions in test_gr
test_gr_methylation <- methodical::summarizeRegionMethylation(tubb6_meth_rse, genomic_regions = test_gr,
  genomic_region_names = names(test_gr))

}
