% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importHumann.R
\name{importHUMAnN}
\alias{importHUMAnN}
\title{Import HUMAnN results to \code{TreeSummarizedExperiment}}
\arguments{
\item{file}{\code{Character scalar}. Defines the file
path of the HUMAnN file. The file must be in merged HUMAnN format.}

\item{col.data}{a DataFrame-like object that includes sample names in
rownames, or a single \code{character} value defining the file
path of the sample metadata file. The file must be in \code{tsv} format
(Default: \code{NULL}).}

\item{colData}{Deprecated. Use \code{col.data} instead.}

\item{...}{additional arguments:
\itemize{
\item \code{assay.type}:  \code{Character scalar}. Specifies the name of
the assay used in calculation. (Default: \code{"counts"})
\item \code{prefix.rm}:  \code{Logical scalar}. Should
taxonomic prefixes be removed? (Default: \code{FALSE})
\item \code{remove.suffix}: \code{Logical scalar}. Should
suffixes of sample names be removed? HUMAnN pipeline adds suffixes
to sample names. Suffixes are formed from file names. By selecting
\code{remove.suffix = TRUE}, you can remove pattern from end of sample
names that is shared by all. (Default: \code{FALSE})
}}
}
\value{
A
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object
}
\description{
Import HUMAnN results to \code{TreeSummarizedExperiment}
}
\details{
Import HUMAnN (currently version 3.0 supported) results of functional
predictions based on metagenome composition (e.g. pathways or gene families).
The input must be in merged HUMAnN format. (See
\href{https://github.com/biobakery/humann#humann_join_tables}{the HUMAnN
documentation and \code{humann_join_tables} method.})

The function parses gene/pathway information along with taxonomy information
from the input file. This information is stored to \code{rowData}. Abundances
are stored to \code{assays}.

Usually the workflow includes also taxonomy data from Metaphlan. See
\link[=importMetaPhlAn]{importMetaPhlAn} to load the data to \code{TreeSE}.
}
\examples{
# File path
file_path <- system.file("extdata", "humann_output.tsv", package = "mia")
# Import data
tse <- importHUMAnN(file_path)
tse

}
\references{
Beghini F, McIver LJ, Blanco-Míguez A, Dubois L, Asnicar F, Maharjan S,
Mailyan A, Manghi P, Scholz M, Thomas AM, Valles-Colomer M, Weingart G,
Zhang Y, Zolfo M, Huttenhower C, Franzosa EA, & Segata N (2021)
Integrating taxonomic, functional, and strain-level profiling of diverse
microbial communities with bioBakery 3. \emph{eLife}. 10:e65088.
}
\seealso{
\code{\link[=importMetaPhlAn]{importMetaPhlAn}}
\code{\link[=convertFromPhyloseq]{convertFromPhyloseq}}
\code{\link[=convertFromBIOM]{convertFromBIOM}}
\code{\link[=convertFromDADA2]{convertFromDADA2}}
\code{\link[=importQIIME2]{importQIIME2}}
\code{\link[=importMothur]{importMothur}}
}
