% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/splitOn.R
\name{splitOn}
\alias{splitOn}
\alias{unsplitOn}
\alias{splitOn,SummarizedExperiment-method}
\alias{splitOn,SingleCellExperiment-method}
\alias{splitOn,TreeSummarizedExperiment-method}
\alias{unsplitOn,list-method}
\alias{unsplitOn,SimpleList-method}
\alias{unsplitOn,SingleCellExperiment-method}
\title{Split \code{TreeSummarizedExperiment} column-wise or row-wise based on
grouping variable}
\usage{
splitOn(x, ...)

unsplitOn(x, ...)

\S4method{splitOn}{SummarizedExperiment}(x, group = f, f = NULL, ...)

\S4method{splitOn}{SingleCellExperiment}(x, group = f, f = NULL, ...)

\S4method{splitOn}{TreeSummarizedExperiment}(
  x,
  group = f,
  f = NULL,
  update.tree = update_rowTree,
  update_rowTree = TRUE,
  ...
)

\S4method{unsplitOn}{list}(x, update.tree = update_rowTree, update_rowTree = TRUE, ...)

\S4method{unsplitOn}{SimpleList}(x, update.tree = update_rowTree, update_rowTree = TRUE, ...)

\S4method{unsplitOn}{SingleCellExperiment}(
  x,
  altexp = altExpNames,
  altExpNames = names(altExps(x)),
  keep.dimred = keep_reducedDims,
  keep_reducedDims = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{Arguments passed to \code{agglomerateByVariable} function for
\code{SummarizedExperiment} objects and other functions.
See \code{\link[=agglomerate-methods]{agglomerateByVariable}} for more
details.
\itemize{
\item \code{use.names}: \code{Logical scalar}. Specifies whether to name
elements of
list by their group names. (Default: \code{TRUE})
}}

\item{group}{\code{Character scalar}, \code{character vector} or
\code{factor vector}. A column name from \code{rowData(x)} or
\code{colData(x)} or alternatively a vector specifying how the merging is
performed. If vector, the value must be the same length as
\code{nrow(x)/ncol(x)}. Rows/Cols corresponding to the same level will be
merged. If \code{length(levels(group)) == nrow(x)/ncol(x)}, \code{x} will be
returned unchanged. If \code{group} matches with both dimensions,
\code{by} must be specified. (Default: \code{NULL})}

\item{f}{Deprecated. Use \code{group} instead.}

\item{update.tree}{\code{Logical scalar}. Should
\code{rowTree()} also be merged? (Default: \code{TRUE})}

\item{update_rowTree}{Deprecated. Use \code{update.tree} instead.}

\item{altexp}{\code{Character vector}. Specify the alternative experiments
to be unsplit. (Default: \code{names(altExps(x))})}

\item{altExpNames}{Deprecated. Use \code{altexp} instead.}

\item{keep.dimred}{\code{Logical scalar}. Should the
\code{reducedDims(x)} be transferred to the result? Please note, that this
breaks the link between the data used to calculate the reduced dims.
(Default: \code{FALSE})}

\item{keep_reducedDims}{Deprecated. Use \code{keep.dimred} instead.}
}
\value{
For \code{splitOn}: \code{SummarizedExperiment} objects in a
\code{SimpleList}.

For \code{unsplitOn}: \code{x}, with \code{rowData} and \code{assay}
data replaced by the unsplit data. \code{colData} of x is kept as well
and any existing \code{rowTree} is dropped as well, since existing
\code{rowLinks} are not valid anymore.
}
\description{
Split \code{TreeSummarizedExperiment} column-wise or row-wise based on
grouping variable
}
\details{
\code{splitOn} split data based on grouping variable. Splitting can be done
column-wise or row-wise. The returned value is a list of
\code{SummarizedExperiment} objects; each element containing members of each
group.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns
# Split data based on SampleType.
se_list <- splitOn(tse, group = "SampleType")

# List of SE objects is returned.
se_list

# Create arbitrary groups
rowData(tse)$group <- sample(1:3, nrow(tse), replace = TRUE)
colData(tse)$group <- sample(1:3, ncol(tse), replace = TRUE)

# Split based on rows
# Each element is named based on their group name. If you don't want to name
# elements, use use_name = FALSE. Since "group" can be found from rowdata and
# colData you must use `by`.
se_list <- splitOn(tse, group = "group", use.names = FALSE, by = 1)

# When column names are shared between elements, you can store the list to
# altExps
altExps(tse) <- se_list

altExps(tse)

# If you want to split on columns and update rowTree, you can do
se_list <- splitOn(tse, group = colData(tse)$group, update.tree = TRUE)

# If you want to combine groups back together, you can use unsplitBy
unsplitOn(se_list)

}
\seealso{
\code{\link[=agglomerate-methods]{agglomerateByRanks}}
\code{\link[=agglomerate-methods]{agglomerateByVariable}},
\code{\link[scuttle:sumCountsAcrossFeatures]{sumCountsAcrossFeatures}},
\code{\link[=agglomerate-methods]{agglomerateByRank}},
\code{\link[SingleCellExperiment:altExps]{altExps}},
\code{\link[SingleCellExperiment:splitAltExps]{splitAltExps}}
}
