% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/utilization_functions.R
\name{getReducedDimAttribute}
\alias{getReducedDimAttribute}
\alias{utilization_functions}
\alias{getReducedDimAttribute,SingleCellExperiment-method}
\title{Utilization functions for \code{TreeSummarizedExperiment} objects}
\usage{
getReducedDimAttribute(x, ...)

\S4method{getReducedDimAttribute}{SingleCellExperiment}(x, dimred = 1L, name = NULL, ...)
}
\arguments{
\item{x}{a \code{\link[SummarizedExperiment]{SummarizedExperiment}} object.}

\item{...}{additional arguments, not used currently.}

\item{dimred}{\code{Character scalar} or \code{integer scalar}. A name or
index of dimension reduction results. (Default: \code{1L})}

\item{name}{\code{Character vector}. A name of values retrieved from
attributes of \code{reducedDim(x, dimred)}. If \code{NULL}, all the values
are retrieved. (Default: \code{NULL})}
}
\value{
The extracted element from the \code{reducedDim} attribute.
}
\description{
A set of utility functions designed to facilitate operations with
\code{TreeSummarizedExperiment} objects
}
\details{
\code{getReducedDimAttribute} is a utility function that retrieves specific
elements from the attributes of \code{reducedDim} in a
\code{TreeSummarizedExperiment} object. These attributes may contain
loadings, statistical test results, or other metadata, depending on the
methods used to generate the results.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns

# Reduce the number of features
tse <- agglomerateByPrevalence(tse, rank = "Phylum")

# Run NMF and add the result to reducedDim(tse, "NMF").
tse <- addNMF(tse, k = 1, name = "NMF")

# Extract feature loadings
res <- getReducedDimAttribute(tse, dimred = "NMF", name = "loadings")
res |> head()

}
\seealso{
\code{\link[=runCCA]{runCCA}}, \code{\link[=addNMF]{addNMF}}, and
\code{\link[=addLDA]{addLDA}}
}
