% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutationCalling.R
\name{pullcountsVars}
\alias{pullcountsVars}
\title{Pull variant counts}
\usage{
pullcountsVars(BaseCounts, vars, cells = NULL)
}
\arguments{
\item{BaseCounts}{A list of base call matrices (one matrix per cell)
as produced by \code{\link{baseCountsFromBamList}}}

\item{vars}{Character vector of variants to pull, in format 5643G>T}

\item{cells}{Character vector for cells to select, or NULL if all
cells from the input are to be used}
}
\value{
A list with two entries, M (count table on the variant
allele) and N (count table on the reference allele)
}
\description{
Pull variant counts
}
\examples{
load(system.file("extdata/example_counts.Rda",package = "mitoClone2"))
known.variants <- c("9 T>C","12 G>A","13 G>A")
counts.known.vars <- pullcountsVars(example.counts, vars=known.variants)
}
