% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matalign.R
\name{matalign}
\alias{matalign}
\title{Matrix Aligner}
\usage{
matalign(
  pcms,
  method = c("Smith-Waterman", "Needleman-Wunsch"),
  pseudo = 1,
  revcomp = TRUE,
  ...
)
}
\arguments{
\item{pcms}{A list of \link{pcm}}

\item{method}{Alignment method. "Smith-Waterman" or "Needleman-Wunsch".
Default is "Smith-Waterma"}

\item{pseudo}{pseudocount}

\item{revcomp}{Check reverseComplement or not.}

\item{...}{Not use.}
}
\value{
A data frame with alignment information. The column names
are motif1, motif2, alignmentScore, startPos1, startPos2, endPos1, endPos2,
alignmentLength.
}
\description{
Matrix Aligner is modified from Matalign-v4a.
Matalign-v4a is a program to compare two positional specific matrices.
The author of Matalign-v4a is Ting Wang and Gary Stormo.
}
\examples{
if(interactive() || Sys.getenv("USER")=="jianhongou"){
  fp <- system.file("extdata", package="motifStack")
  fs <- dir(fp, "pcm$")
  pcms <- importMatrix(file.path(fp, fs), format="pcm")
  matalign(pcms)
 }
}
