% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pssm.R
\docType{class}
\name{pssm-class}
\alias{pssm-class}
\alias{pssm}
\alias{$,pssm-method}
\alias{$<-,pssm-method}
\alias{plot,pssm,ANY-method}
\alias{coerce()}
\alias{coerce,pssm,matrix-method}
\alias{matrixReverseComplement,pssm-method}
\alias{addBlank,pssm,numeric,logical-method}
\alias{as.data.frame,pssm-method}
\alias{format,pssm-method}
\title{Class \code{"pssm"}}
\usage{
\S4method{$}{pssm}(x, name)

\S4method{plot}{pssm,ANY}(x, y = "missing", ...)

\S4method{matrixReverseComplement}{pssm}(x)

\S4method{addBlank}{pssm,numeric,logical}(x, n, b)

\S4method{as.data.frame}{pssm}(x, row.names = NULL, optional = FALSE, ...)

\S4method{format}{pssm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{pssm}. For \code{getIC}, if parameter p is
followed, x should be an object of matrix.}

\item{name}{Slot name.}

\item{y}{Not use.}

\item{\dots}{Further potential arguments passed to \code{plotMotifLogo}.}

\item{n}{how many spaces should be added.}

\item{b}{logical value to indicate where the space should be added.}

\item{row.names, optional}{see as.data.frame}
}
\description{
An object of class \code{"pssm"} represents the position specific score 
matrix of a DNA/RNA/amino-acid sequence motif. The entry stores a matrix, 
which in row i, column j gives the log-odds probability of nucleotide/or 
amino acid i in position j of the motif.

methods for pssm objects.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("pssm", mat, name, alphabet, color, background)}.
}

\section{Methods}{
 \describe{ \item{addBlank}{\code{signature(x="pssm",
n="numeric", b="logical")} add space into the position frequency matrix for
alignment. b is a bool value, if TRUE, add space to the 3' end, else add
space to the 5' end. n indicates how many spaces should be added.}

\item{matrixReverseComplement}{\code{signature(x = "pssm")} get the reverse
complement of position frequency matrix.}

\item{plot}{\code{signature(x = "pssm")} Plots the sequence logo of the
position frequency matrix. }

\item{$, $<-}{Get or set the slot of \code{\link{pssm-class}}}
\item{as.data.frame}{convert \code{\link{pssm-class}} to a data.frame}
\item{format}{return the name_pssm of \code{\link{pssm-class}}} }
}

\examples{

pcm <- read.table(file.path(find.package("motifStack"), 
                            "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- pcm2pssm(pcm)
motif <- new("pssm", mat=motif, name="bin_SOLEXA")
plot(motif)


pcm <- read.table(file.path(find.package("motifStack"), 
                  "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- pcm2pssm(pcm)
motif <- new("pssm", mat=motif, name="bin_SOLEXA")
matrixReverseComplement(motif)
addBlank(motif, 1, FALSE)
addBlank(motif, 3, TRUE)
as(motif,"matrix")
as.data.frame(motif)
format(motif)

}
\keyword{classes}
