% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{combine_count_tables}
\alias{combine_count_tables}
\title{Combines tables into a single table that can be used for discovery/prediction}
\usage{
combine_count_tables(
  musica,
  to_comb,
  name,
  description = character(),
  color_variable = character(),
  color_mapping = character(),
  overwrite = FALSE
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{to_comb}{A vector of table names to combine. Each table must already
exist within the input musica object}

\item{name}{Name of table build, must be a new name}

\item{description}{Description of the new table}

\item{color_variable}{Annotation column to use for coloring plotted motifs,
provided by counts table from input result's musica object}

\item{color_mapping}{Mapping from color_variable to color names, provided by
counts table from input result's musica object}

\item{overwrite}{Overwrite existing count table}
}
\value{
None
}
\description{
Combines tables into a single table that can be used for discovery/prediction
}
\examples{
g <- select_genome("19")

data(musica)
build_standard_table(musica, g, "SBS96", overwrite = TRUE)

annotate_transcript_strand(musica, "19")
build_standard_table(musica, g, "SBS192", "Transcript_Strand")

combine_count_tables(musica, c("SBS96", "SBS192_Trans"), "combo")
}
