% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-tagm-mcmc-helper.R
\name{mcmc_get_outliers}
\alias{mcmc_get_outliers}
\alias{mcmc_get_meanComponent}
\alias{mcmc_get_meanoutliersProb}
\alias{geweke_test}
\alias{mcmc_pool_chains}
\alias{mcmc_burn_chains}
\alias{mcmc_thin_chains}
\alias{plot,MCMCParams,character-method}
\title{Number of outlier at each iteration of MCMC}
\usage{
mcmc_get_outliers(x)

mcmc_get_meanComponent(x)

mcmc_get_meanoutliersProb(x)

geweke_test(k)

mcmc_pool_chains(param)

mcmc_burn_chains(x, n = 50)

mcmc_thin_chains(x, freq = 5)

\S4method{plot}{MCMCParams,character}(x, y, ...)
}
\arguments{
\item{x}{Object of class \code{MCMCParams}}

\item{k}{A \code{list} of \link[coda:mcmc]{coda::mcmc} objects, as returned by
\code{mcmc_get_outliers}, \code{mcmc_get_meanComponent} and
\code{mcmc_get_meanoutliersProb}.}

\item{param}{An object of class \code{MCMCParams}.}

\item{n}{\code{integer(1)} defining number of iterations to burn. The default is
\code{50}}

\item{freq}{Thinning frequency. The function retains every `freq`th iteration
and is an `integer(1)`. The default thinning frequency is `5`.}

\item{y}{A `character(1)` with a protein name.}

\item{...}{Currently ignored.}
}
\value{
A \code{list} of length \code{length(x)}.

A \code{list} of length \code{length(x)}.

A \code{list} of length \code{length(x)}.

A \code{matrix} with the test z- and p-values for each chain.

A pooled \code{MCMCParams} object.

An updated \code{MCMCParams} object.

A thinned `MCMCParams` object.

A ggplot2 object.
}
\description{
Helper function to get the number of outlier at each MCMC
iteration.

Helper function to get mean component allocation at each MCMC
iteration.

Helper function to get mean probability of belonging to outlier at
each iteration.

Wrapper for the geweke diagnostics from coda package also return p-values.

Helper function to pool chains together after processing

Helper function to burn n iterations from the front of the chains

Helper function to subsample the chains, known informally as
thinning.

Produces a violin plot with the protein posterior probabilities
distributions for all organelles.
}
\author{
Laurent Gatto
}
