% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFolds.R
\name{makeFolds}
\alias{makeFolds}
\title{Divide observations into folds}
\usage{
makeFolds(nfolds, data, cvType, coords)
}
\arguments{
\item{nfolds}{The number of folds}

\item{data}{the dataset}

\item{cvType}{a character vector, indicating the type of cross-validation required, either blocked or random}

\item{coords}{the names of the coordinates in data}
}
\value{
the vector of folds
}
\description{
Divide observations into folds
}
\examples{
nfolds <- 10
data <- expand.grid("x" = seq_len(10), "y" = seq_len(10))
randomFolds <- makeFolds(nfolds = nfolds, data, "random", c("x", "y"))
blockedFolds <- makeFolds(nfolds = nfolds, data, "blocked", c("x", "y"))
}
