% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyPartitionMetrics.R
\name{fuzzyPartitionMetrics}
\alias{fuzzyPartitionMetrics}
\title{Compute fuzzy-fuzzy versions of pair-sorting partition metrics}
\usage{
fuzzyPartitionMetrics(
  P,
  Q,
  computeWallace = TRUE,
  nperms = NULL,
  verbose = TRUE,
  returnElementPairAccuracy = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  tnorm = c("product", "min", "lukasiewicz")
)
}
\arguments{
\item{P}{A object coercible to a numeric matrix with membership probability
of elements (rows) in ground-truth classes (columns).}

\item{Q}{A object coercible to a numeric matrix with membership probability
of elements (rows) in predicted clusters (columns). Must have the same
number of rows as \code{P}.}

\item{computeWallace}{Logical; whether to compute the individual fuzzy
versions of the Wallace indices (increases running time).}

\item{nperms}{The number of permutations (for correction for chance). If
NULL (default), a first set of 10 permutations will be run to estimate
whether the variation across permutations is above 0.0025, in which case
more (max 1000) permutations will be run.}

\item{verbose}{Logical; whether to print info and warnings, including the
standard error of the mean across permutations (giving an idea of the
precision of the adjusted metrics).}

\item{returnElementPairAccuracy}{Logical. If TRUE, returns the per-element
pair accuracy instead of the various parition-level and dataset-level
metrics. Default FALSE.}

\item{BPPARAM}{BiocParallel params for multithreading (default none)}

\item{tnorm}{Which type of t-norm operation to use for class membership of
pairs (either product, min, or lukasiewicz) when calculating the Wallace
indices. Does not influence the NDC/ACI metrics.}
}
\value{
When \code{returnElementPairAccuracy} is \code{FALSE}, return a list of
metrics:
\item{NDC}{Hullermeier's NDC (fuzzy rand index)}
\item{ACI}{Ambrosio's Adjusted Concordance Index (ACI), i.e. a
permutation-based fuzzy version of the adjusted Rand index.}
\item{fuzzyWH}{Fuzzy Wallace Homogeneity index}
\item{fuzzyWC}{Fuzzy Wallace Completeness index}
\item{fuzzyAWH}{Adjusted fuzzy Wallace Homogeneity index}
\item{fuzzyAWC}{Adjusted fuzzy Wallace Completeness index}
}
\description{
Computes fuzzy versions of pair-sorting partition metrics. This is largely
based on the permutation-based implementation by Antonio D'Ambrosio from the
\code{ConsRankClass} package, modified to also compute the fuzzy versions of the
adjusted Wallace indices, implement multithreading, and adjust the number of
permutations according to their variability.
}
\examples{
# generate fuzzy partitions:
}
\references{
Hullermeier et al. 2012; 10.1109/TFUZZ.2011.2179303;

D'Ambrosio et al. 2021; 10.1007/s00357-020-09367-0
}
\author{
Pierre-Luc Germain
}
