% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{permMclust}
\alias{permMclust}
\title{permMclust}
\usage{
permMclust(y, nperms, condition, remove.zeroes = TRUE, log.transf = TRUE,
  restrict = FALSE, alpha, m0, s0, a0, b0, ref, min.size)
}
\arguments{
\item{y}{Numeric data vector for one gene}

\item{nperms}{Number of permutations of residuals to evaulate}

\item{condition}{Vector of condition indicators for each sample}

\item{remove.zeroes}{Logical indicating whether 
zeroes need to be removed from \code{y}}

\item{log.transf}{Logical indicating whether the data is 
in the raw scale (if so, will be log-transformed)}

\item{restrict}{Logical indicating whether to perform restricted Mclust
clustering where close-together clusters are joined.}

\item{alpha}{Value for the Dirichlet concentration parameter}

\item{m0}{Prior mean value for generating distribution of cluster means}

\item{s0}{Prior precision value for generating distribution of cluster means}

\item{a0}{Prior shape parameter value for the generating distribution of 
cluster precision}

\item{b0}{Prior scale parameter value for the generating distribution of 
cluster precision}

\item{ref}{one of two possible values in condition; 
represents the referent category.}

\item{min.size}{a positive integer that specifies the minimum size of a 
cluster (number of cells) for it to be used
 during the classification step.  Any clusters containing fewer than 
 \code{min.size} cells will be considered an outlier
 cluster and ignored in the classfication algorithm.  The default value
  is three.}
}
\value{
Bayes factor numerator for the current permutation
}
\description{
Function to  obtain bayes factor numerator for permutations of one gene
}
\details{
Obtains bayes factor numerator for data vector
 \code{y} representing one gene
}
\references{
Korthauer KD, Chu LF, Newton MA, Li Y, Thomson J, Stewart R,
 Kendziorski C. A statistical approach for identifying differential 
 distributions
in single-cell RNA-seq experiments. Genome Biology. 2016 Oct 25;17(1):222. 
\url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-016-
1077-y}
}
