% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCzinb_internal.R
\name{zinb.regression.parseModel}
\alias{zinb.regression.parseModel}
\title{Parse ZINB regression model}
\usage{
zinb.regression.parseModel(alpha, A.mu, A.pi)
}
\arguments{
\item{alpha}{the vectors of parameters c(a.mu, a.pi) concatenated}

\item{A.mu}{matrix of the model (default=empty)}

\item{A.pi}{matrix of the model (default=empty)}
}
\value{
A list with slots \code{logMu}, \code{logitPi}, \code{dim.alpha} (a
vector of length 2 with the dimension of each of the vectors \code{a.mu},
\code{a.pi}  in \code{alpha}), and \code{start.alpha} (a vector
of length 2 with the starting indices of the 2 vectors in \code{alpha})
}
\description{
Given the parameters of a ZINB regression model, this function parses the
model and computes the vector of log(mu), logit(pi), and the dimensions of
the different components of the vector of parameters.
}
\keyword{internal}
