% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxds_bcds_hybrid.R
\name{cxds_bcds_hybrid}
\alias{cxds_bcds_hybrid}
\title{Find doublets/multiples in UMI scRNA-seq data;}
\usage{
cxds_bcds_hybrid(sce, cxdsArgs = NULL, bcdsArgs = NULL, verb = FALSE,
  estNdbl = FALSE, force = FALSE)
}
\arguments{
\item{sce}{single cell experiment (\code{SingleCellExperiment}) object to analyze; needs \code{counts} in assays slot.}

\item{cxdsArgs}{list, arguments for cxds function in list form. Default: NULL}

\item{bcdsArgs}{list, arguments for bcds function in list form. Default: NULL}

\item{verb}{logical, switch on/off progress messages}

\item{estNdbl}{logical, should the numer of doublets be estimated from the data. Enables doublet calls. Default:FALSE. Use with caution.}

\item{force}{logical, force a (re)run of \code{cxds} and \code{bcds}. Default: FALSE}
}
\value{
sce input sce object \code{SingleCellExperiment} with doublet scores added to colData as "hybrid_score" column.
}
\description{
Annotates doublets/multiplets using the hybrid approach
}
\examples{
data("sce_chcl")
## create small data set using only 100 cells
sce_chcl_small = sce_chcl[, 1:100]
sce_chcl_small = cxds_bcds_hybrid(sce_chcl_small)
}
