% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGeneSets.R
\name{importGeneSetsFromCollection}
\alias{importGeneSetsFromCollection}
\title{Imports gene sets from a GeneSetCollection object}
\usage{
importGeneSetsFromCollection(
  inSCE,
  geneSetCollection,
  collectionName = "GeneSetCollection",
  by = "rownames",
  noMatchError = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{geneSetCollection}{A \linkS4class{GeneSetCollection} object. See
\link{GeneSetCollection} for more details.}

\item{collectionName}{Character. Name of collection to add gene sets to.
If this collection already exists in \code{inSCE}, then these gene sets will
be added to that collection. Any gene sets within the collection with the
same name will be overwritten. Default \code{GeneSetCollection}.}

\item{by}{Character, character vector, or NULL. Describes the
location within \code{inSCE} where the gene identifiers in
\code{geneSetCollection} should be mapped. If set to \code{"rownames"} then the
features will be searched for among \code{rownames(inSCE)}. This can also be
set to one of the column names of \code{rowData(inSCE)} in which case the
gene identifies will be mapped to that column in the \code{rowData}
of \code{inSCE}. \code{by} can be a vector the same length as
the number of gene sets in the \code{GeneSetCollection} and the elements of the vector
can point to different locations within \code{inSCE}. Finally, \code{by}
can be \code{NULL}. In this case, the location of the gene identifiers
in \code{inSCE} should be saved in the description slot for each gene set
in the \code{GeneSetCollection}.
See \link{featureIndex} for more information.
Default \code{"rownames"}.}

\item{noMatchError}{Boolean. Show an error if a collection does not have
any matching features. Default \code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object
with gene set from \code{collectionName} output stored to the
\link{metadata} slot.
}
\description{
Converts a list of gene sets stored in a
\linkS4class{GeneSetCollection} object and stores it in the metadata of the
\linkS4class{SingleCellExperiment} object. These gene sets can be used in
downstream quality control and analysis functions in \link{singleCellTK}.
}
\details{
The gene identifiers in gene sets in the
\code{GeneSetCollection} will be mapped to the rownames of
\code{inSCE} using the \code{by} parameter and
stored in a \linkS4class{GeneSetCollection} object from package
\link{GSEABase}. This object is stored in
\code{metadata(inSCE)$sctk$genesets}, which can be accessed in downstream
analysis functions such as \link[singleCellTK]{runCellQC}.
}
\examples{
data(scExample)
gs1 <- GSEABase::GeneSet(setName = "geneset1",
                         geneIds = rownames(sce)[seq(10)])
gs2 <- GSEABase::GeneSet(setName = "geneset2",
                         geneIds = rownames(sce)[seq(11,20)])
gsc <- GSEABase::GeneSetCollection(list(gs1, gs2))
sce <- importGeneSetsFromCollection(inSCE = sce,
                                    geneSetCollection = gsc,
                                    by = "rownames")
}
\seealso{
\link{importGeneSetsFromList} for importing from lists,
\link{importGeneSetsFromGMT} for importing from GMT files, and
\link{importGeneSetsFromMSigDB} for importing MSigDB gene sets.
}
\author{
Joshua D. Campbell
}
