% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyPCAGeneRanking}
\alias{plotScanpyPCAGeneRanking}
\title{plotScanpyPCAGeneRanking}
\usage{
plotScanpyPCAGeneRanking(inSCE, PC_comp = "1,2,3", includeLowest = TRUE)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{PC_comp}{For example, '1,2,3' means [1, 2, 3], first, second, 
third principal component.}

\item{includeLowest}{Whether to show the variables with both highest and 
lowest loadings. Default \code{TRUE}}
}
\value{
plot object
}
\description{
plotScanpyPCAGeneRanking
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
plotScanpyPCAGeneRanking(sce)
}
}
