% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlReports.R
\name{reportDropletQC}
\alias{reportDropletQC}
\title{Get runDropletQC .html report}
\usage{
reportDropletQC(
  inSCE,
  output_file = NULL,
  output_dir = NULL,
  subTitle = NULL,
  studyDesign = NULL
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
the full droplet count matrix with the output from runDropletQC function}

\item{output_file}{name of the generated file. If NULL/default then the output file name will be based on the name of the Rmarkdown template}

\item{output_dir}{name of the output directory to save the rendered file. If NULL/default the file is stored to the current working directory}

\item{subTitle}{subtitle of the QC HTML report. Default is NULL.}

\item{studyDesign}{description of the data set and experiment design. It would be shown at the top of QC HTML report. Default is NULL.}
}
\value{
.html file
}
\description{
A  function to generate .html Rmarkdown report containing the visualizations of the runDropletQC function output
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runDropletQC(sce)
reportDropletQC(inSCE = sce)
}
}
