% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runQC.R
\name{runDropletQC}
\alias{runDropletQC}
\title{Perform comprehensive droplet QC}
\usage{
runDropletQC(
  inSCE,
  algorithms = c("QCMetrics", "emptyDrops", "barcodeRanks"),
  sample = NULL,
  useAssay = "counts",
  paramsList = NULL
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
the full droplet count matrix}

\item{algorithms}{Character vector. Specify which QC algorithms to run.
Available options are "emptyDrops" and "barcodeRanks".}

\item{sample}{Character vector. Indicates which sample each cell belongs to.
Algorithms will be run on cells from each sample separately.}

\item{useAssay}{A string specifying which assay contains the count
matrix for droplets.}

\item{paramsList}{A list containing parameters for QC functions. Default NULL.}
}
\value{
SingleCellExperiment object containing the outputs of the
 specified algorithms in the \link{colData}
of \code{inSCE}.
}
\description{
A wrapper function to run several QC algorithms for determining
empty droplets in single cell RNA-seq data
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runDropletQC(sce)
}
}
