% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permuTest.R
\name{getPvals}
\alias{getPvals}
\title{Estimate the empirical p-values}
\usage{
getPvals(permuteResult, scoredf, subSamples = NULL)
}
\arguments{
\item{permuteResult}{A matrix, null distributions for each sample generated
using the \code{\link[=generateNull]{generateNull()}} function}

\item{scoredf}{A dataframe, the scored results of samples under test
generated using the \code{\link[=simpleScore]{simpleScore()}} function}

\item{subSamples}{A vector of sample labels/indices that will be used to
subset the score matrix. All samples will be scored if not provided}
}
\value{
Estimated p-values for enrichment of the signature in each sample. A
p-value of 1/B indicates that the estimated p-value is less than or equal
to 1/B.
}
\description{
With null distributions estimated using the \code{\link[=generateNull]{generateNull()}}
function, p-values are estimated using a one-tailed test. A minimum p-value
of 1/B can be achieved with B permutations.
}
\examples{
ranked <- rankGenes(toy_expr_se)
scoredf <- simpleScore(ranked, upSet = toy_gs_up, downSet = toy_gs_dn)
# find out what backends can be registered on your machine
BiocParallel::registered()
# the first one is the default backend, and it can be changed explicitly.
# See vignette for more details
permuteResult = generateNull(upSet = toy_gs_up, downSet = toy_gs_dn, ranked,
B =10, seed = 1, useBPPARAM = NULL)

# call the permutation function to generate the empirical scores
# for B times.
pvals <- getPvals(permuteResult,scoredf)
}
