% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeToXlsx.R
\name{writeToXlsx}
\alias{writeToXlsx}
\title{Write effect sizes and p-values results to an excel worksheet}
\usage{
writeToXlsx(obj, file, overwrite = FALSE, digits = 3, sigLevel = 0.05)
}
\arguments{
\item{obj}{The results of linear model fitting}

\item{file}{The file to write the results to}

\item{overwrite}{A boolean, should the file be overwritten if it exists already?}

\item{digits}{An integer, the number of significant digits to retain for the PI,
raw and adjusted p-values}

\item{sigLevel}{The significance level threshold to use for the adjusted p-values,
only features exceeding the threshold are written to the file. Set this parameter to 1 to write all features}
}
\value{
Returns invisible with a message when writing operation successful,
otherwise throws an error.
}
\description{
The results of the linear models are written to an excel spreadsheet with different tabs for every sign (PI smaller than or larger than 0.5) of every PI,
sorted by increasing p-value.
}
\details{
If no feature exceeds the significance threshold for a certain pi and parameter combination,
an empty tab is created. For fixed effects, a single tab is written for PI differences of any sign.
The "baseline" tabs indicate the overall patterns, the other tabs are named after the fixed effects
and indicate departure from this baseline depending on this fixed effect
}
\examples{
example(fitLMMs, "smoppix")
writeToXlsx(lmmModels, "tmpFile.xlsx")
file.remove("tmpFile.xlsx")
}
\seealso{
\link[openxlsx]{createWorkbook},\link[openxlsx]{writeData}, \link[openxlsx]{addWorksheet}, \link[openxlsx]{saveWorkbook}
}
