% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructShapePPP.R
\name{reconstructShapeDensityImage}
\alias{reconstructShapeDensityImage}
\title{Reconstruct structure from spe object with given image id}
\usage{
reconstructShapeDensityImage(
  spe,
  marks,
  imageCol = NULL,
  imageId = NULL,
  markSelect,
  dim = 500,
  bndw = NULL,
  thres = NULL,
  complement = FALSE
)
}
\arguments{
\item{spe}{SpatialExperiment; a object of class \code{SpatialExperiment}}

\item{marks}{character; name of column in \code{colData} that will correspond
to the \code{ppp} marks}

\item{imageCol}{character; name of a column in \code{colData} that corresponds
to the image}

\item{imageId}{character; image id, must be present in imageCol}

\item{markSelect}{character; name of mark that is to be selected for the
reconstruction}

\item{dim}{numeric; x dimension of the final reconstruction.
A lower resolution speed up computation but lead to less exact reconstruction.
Default = 500}

\item{bndw}{numeric; smoothing bandwidth in the density estimation,
corresponds to the \code{sigma} parameter in the \code{density.ppp} function,
if no value is given the bandwidth is estimated using cross validation with
the \code{bw.diggle} function.}

\item{thres}{numeric; intensity threshold for the reconstruction;
if NULL the threshold is set as the mean between the mode of the pixel intensity
distributions}

\item{complement}{logical; reconstruct everything but the mark of interest, default = \code{FALSE}}
}
\value{
sf object of class \code{POLYGON}
}
\description{
Reconstruct structure from spe object with given image id
}
\examples{
data("sostaSPE")
struct <- reconstructShapeDensityImage(sostaSPE,
    marks = "cellType", imageCol = "imageName", imageId = "image1",
    markSelect = "A", dim = 500
)
plot(struct)
}
