% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructShapePPP.R
\name{reconstructShapeDensitySPE}
\alias{reconstructShapeDensitySPE}
\title{Reconstruct structure from spatial experiment object per image id}
\usage{
reconstructShapeDensitySPE(
  spe,
  marks,
  imageCol = NULL,
  markSelect,
  dim = 500,
  bndw = NULL,
  thres = NULL,
  complement = FALSE,
  nCores = 1
)
}
\arguments{
\item{spe}{SpatialExperiment; a object of class \code{SpatialExperiment}}

\item{marks}{character; name of column in \code{colData} that will correspond
to the \code{ppp} marks}

\item{imageCol}{character; name of a column in \code{colData} that corresponds
to the image}

\item{markSelect}{character; name of mark that is to be selected for the
reconstruction}

\item{dim}{numeric; x dimension of the final reconstruction.
A lower resolution speed up computation but lead to less exact reconstruction.
Default = 500}

\item{bndw}{numeric; bandwidth of the sigma parameter in the density estimation,
if no value is given the bandwidth is estimated using cross validation with
the \code{bw.diggle} function for each image individually.}

\item{thres}{numeric; intensity threshold for the reconstruction;
if NULL the threshold is set as the mean between the mode of the pixel intensity
distributions estimated for each image individual}

\item{complement}{logical; reconstruct everything but the mark of interest, default = \code{FALSE}}

\item{nCores}{numeric; number of cores for parallel processing using
\code{mclapply}. Default = 1}
}
\value{
simple feature collection
}
\description{
Reconstruct structure from spatial experiment object per image id
}
\examples{
data("sostaSPE")
allStructs <- reconstructShapeDensitySPE(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    markSelect = "A", bndw = 3.5, thres = 0.005
)
allStructs
}
