% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMdl.R
\name{plotMdl}
\alias{plotMdl}
\title{Plot a pffr model object}
\usage{
plotMdl(mdl, predictor, shift = NULL)
}
\arguments{
\item{mdl}{a \code{pffr} model object}

\item{predictor}{predictor to plot}

\item{shift}{the value by which to shift the centered functional intercept.
this will most often be the constant intercept}
}
\value{
ggplot object of the functional estimate
}
\description{
A function that takes a pffr object as calculated in \code{functionalGam} and
plots the functional coefficients. The functions are centered such that their
expected value is zero. Therefore, the scalar intercept has to be added to
the output with the argument \code{shift} in order to plot the coefficients in
their original range.
}
\examples{
library("tidyr")
library("stringr")
library("dplyr")
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
metricRes <- calcMetricPerFov(spe, c("alpha", "Tc"),
    subsetby = "image_number", fun = "Gcross", marks = "cell_type",
    rSeq = seq(0, 50, length.out = 50), by = c(
        "patient_stage", "patient_id",
        "image_number"
    ),
    ncores = 1
)
# create a unique ID for each row
metricRes$ID <- paste0(
    metricRes$patient_stage, "x", metricRes$patient_id,
    "x", metricRes$image_number
)

dat <- prepData(metricRes, "r", "rs", sample_id = "patient_id",
    image_id = "image_number", condition = "patient_stage")

#' # drop rows with NA
dat <- dat |> drop_na()

# create a designmatrix
condition <- dat$patient_stage
# relevel the condition - can set explicit contrasts here
condition <- relevel(condition, "Non-diabetic")
designmat <- model.matrix(~condition)
# colnames don't work with the '-' sign
colnames(designmat) <- c(
    "(Intercept)", "conditionLong_duration",
    "conditionOnset"
)
# fit the model
mdl <- functionalGam(
    data = dat, x = metricRes$r |> unique(),
    designmat = designmat, weights = dat$npoints,
    formula = formula(Y ~ conditionLong_duration +
        conditionOnset + s(patient_id, bs = "re")),
        algorithm = "bam"
)
summary(mdl)
plotLs <- lapply(colnames(designmat), plotMdl,
    mdl = mdl,
    shift = mdl$coefficients[["(Intercept)"]]
)
}
