% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addInteractionAnnotation.R
\name{addInteractionAnnotation}
\alias{addInteractionAnnotation}
\title{Add annotation markers to the figure at a given position}
\usage{
addInteractionAnnotation(
  obj,
  idx,
  FUN = grid.polygon,
  panel = c("top", "bottom"),
  ...
)
}
\arguments{
\item{obj}{A \link[InteractionSet:GInteractions-class]{GInteractions} object,
\link[GenomicRanges:GRanges-class]{GRanges} object or numeric vector.
For numeric vector, the positive value will generate a line with slope 1 and
negative value will generate a line at the position with slope -1.}

\item{idx}{The layer number of track.}

\item{FUN}{Function for plot. Available functions are 
\link[grid:grid.polygon]{grid.polygon}, \link[grid:grid.lines]{grid.lines},
and \link[grid:grid.text]{grid.text} for GInteractions object;
\link[grid:grid.lines]{grid.lines},
and \link[grid:grid.text]{grid.text} for GRanges object;
FUN is not used for numeric vector.}

\item{panel}{Plot regions. Available values are "top", "bottom".}

\item{...}{Parameters will be passed to FUN.}
}
\value{
invisible viewport for plot region.
}
\description{
A function to add annotation markers for emphasizing interactions
}
\examples{
library(trackViewer)
library(InteractionSet)
gi <- readRDS(system.file("extdata", "nij.chr6.51120000.53200000.gi.rds",
 package="trackViewer"))
tads <- GInteractions(
GRanges("chr6", 
        IRanges(c(51130001, 51130001, 51450001, 52210001), width = 20000)),
GRanges("chr6", 
        IRanges(c(51530001, 52170001, 52210001, 53210001), width = 20000)))
range <- GRanges("chr6", IRanges(51120000, 53200000))
tr <- gi2track(gi)
viewTracks(trackList(tr), 
           gr=range, autoOptimizeStyle = TRUE)
addInteractionAnnotation(tads, "tr", grid.lines,
 gp=gpar(col = "#E69F00", lwd=3, lty=3))

}
\seealso{
See Also as \code{\link{addGuideLine}}, \code{\link{addArrowMark}}
}
