% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIdeo.R
\name{plotIdeo}
\alias{plotIdeo}
\title{plot ideogram}
\usage{
plotIdeo(
  ideo,
  chrom = seqlevels(ideo)[1],
  colorSheme = gieStain(),
  gp = gpar(fill = NA),
  ...
)
}
\arguments{
\item{ideo}{output of \link{loadIdeogram}.}

\item{chrom}{A length 1 character vector of chromosome name.}

\item{colorSheme}{A character vector of giemsa stain colors.}

\item{gp}{parameters used for \link[grid]{grid.roundrect}.}

\item{...}{parameters not used.}
}
\description{
plot ideogram for one chromosome
}
\examples{
\dontrun{
ideo <- loadIdeogram("hg38")
library(grid)
grid.newpage()
plotIdeo(ideo)
}


}
