% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewGene.R
\name{viewGene}
\alias{viewGene}
\title{plot tracks based on gene name}
\usage{
viewGene(
  symbol,
  filenames,
  format,
  txdb,
  org,
  upstream = 1000,
  downstream = 1000,
  anchor = c("gene", "TSS"),
  plot = FALSE
)
}
\arguments{
\item{symbol}{Gene symbol}

\item{filenames}{files used to generate tracks}

\item{format}{file format used to generate tracks}

\item{txdb}{txdb will be used to extract the genes}

\item{org}{org package name}

\item{upstream}{upstream from anchor}

\item{downstream}{downstream from anchor}

\item{anchor}{TSS, or gene}

\item{plot}{plot the tracks or not.}
}
\value{
an invisible list of a \code{\link{trackList}},
 a \code{\link{trackViewerStyle}} and a \code{\link[GenomicRanges:GRanges-class]{GRanges}}
}
\description{
given a gene name, plot the tracks.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
extdata <- system.file("extdata", package="trackViewer", mustWork=TRUE)
filename = file.path(extdata, "fox2.bed")
optSty <- viewGene("HSPA8", filenames=filename, format="BED", 
                   txdb=TxDb.Hsapiens.UCSC.hg19.knownGene, 
                   org="org.Hs.eg.db")

}
