## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

library(SummarizedExperiment)
library(ExperimentHub)
library(DoReMiTra)

## ----install, eval = FALSE----------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#   install.packages("BiocManager")
# }
# 
# BiocManager::install("DoReMiTra")

## ----loadlib------------------------------------------------------------------
library("DoReMiTra")

## ----list-datasets------------------------------------------------------------
datasets <- list_DoReMiTra_datasets()
knitr::kable(datasets)

## ----load-all-datasets, eval= FALSE-------------------------------------------
# 
# all_SEs <- get_all_DoReMiTra_datasets()
# 
# # Now you can access any loaded dataset by its name, for example:
# all_SEs[["SE_Salah_2025_ExVivo"]]

## ----search-datasets----------------------------------------------------------
search_DoReMiTra_datasets(radiation_type = "gamma ray", 
                          organism = "Homo sapiens", 
                          exp_setting = "ExVivo")

## ----load-dataset-------------------------------------------------------------
search_DoReMiTra_datasets(radiation_type = "X-ray", 
                          organism = "Homo sapiens", 
                          exp_setting = "ExVivo")

dataset_name <- "SE_Broustas_2017_ExVivo_GSE90909_GPL13497"
se <- get_DoReMiTra_data(dataset_name, gene_symbol = TRUE)
se

## ----explore-dataset----------------------------------------------------------
assay(se)[1:5, 1:5] # expression matrix
head(rowData(se)) # gene info
head(colData(se)) # sample info

## ----summarize----------------------------------------------------------------
summarize_DoReMiTra_se(se)

## ----compare------------------------------------------------------------------
search_DoReMiTra_datasets(radiation_type = "gamma ray", 
                          organism = "Homo sapiens", 
                          exp_setting = "ExVivo")

se1 <- get_DoReMiTra_data("SE_Park_2017_ExVivo_GSE102971_GPL10332_HomoSapiens")
se2 <- get_DoReMiTra_data("SE_Paul_2013_ExVivo_GSE44201_GPL6480")
se_list<- list(
  Park = se1, 
  Paul = se2
)
compare_DoReMiTra_datasets(se_list = se_list)

## ----session------------------------------------------------------------------
sessionInfo()

