% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDeconvolution.R
\name{runDeconvolution}
\alias{runDeconvolution}
\title{Run Deconvolution using NNLS model}
\usage{
runDeconvolution(
  x,
  mod,
  ref,
  scale = TRUE,
  min_prop = 0.01,
  verbose = TRUE,
  slot = "counts",
  L1_nnls_topics = 0,
  L2_nnls_topics = 0,
  L1_nnls_prop = 0,
  L2_nnls_prop = 0,
  threads = 0,
  ...
)
}
\arguments{
\item{x}{mixture dataset. Can be a numeric matrix,
\code{SingleCellExperiment} or \code{SpatialExperiment}}

\item{mod}{object as obtained from trainNMF.}

\item{ref}{object of class matrix containing the topic profiles for each cell
type as obtained from trainNMF.}

\item{scale}{logical specifying whether to scale single-cell counts to unit
variance. This gives the user the option to normalize the data beforehand
as you see fit (CPM, FPKM, ...) when passing a matrix or specifying the
slot from where to extract the count data.}

\item{min_prop}{scalar in [0,1] setting the minimum contribution
expected from a cell type in \code{x} to observations in \code{y}.
By default 0.}

\item{verbose}{logical. Should information on progress be reported?}

\item{slot}{If the object is of class \code{SpatialExperiment} indicates 
matrix to use. By default "counts".}

\item{L1_nnls_topics, L1_nnls_prop}{LASSO penalty in the range (0, 1] for NNLS
when computing cell type topic profiles and cell type proportions
respectively. Larger values remove "noisy" contributions more aggressively.}

\item{L2_nnls_topics, L2_nnls_prop}{RIDGE penalty >0 for NNLS when computing
cell type topic profiles and cell type proportions respectively.
Larger values remove "noisy" contributions more aggressively.}

\item{threads}{number of threads to use, default 0 (all threads)}

\item{...}{additional parameters.}
}
\value{
base a list where the first element is a list giving the NMF model and
  the second is a matrix containing the topic profiles learnt.
}
\description{
This function takes in the mixture data, the trained model & the
  topic profiles and returns the proportion of each cell type within each
   mixture
}
\examples{
set.seed(321)
# mock up some single-cell, mixture & marker data
sce <- mockSC(ng = 200, nc = 10, nt = 3)
spe <- mockSP(sce)
mgs <- getMGS(sce)

res <- trainNMF(
    x = sce,
    y = rownames(spe),
    groups = sce$type,
    mgs = mgs,
    weight_id = "weight",
    group_id = "type",
    gene_id = "gene")
# Run deconvolution
decon <- runDeconvolution(
    x = spe,
    mod = res[["mod"]],
    ref = res[["topic"]])
}
\author{
Marc Elosua Bayes, Zach DeBruine, and Helena L Crowell
}
