% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.files.R
\name{FcsToTibble}
\alias{FcsToTibble}
\title{Takes a file as input and returns a data frame of cells by features}
\usage{
FcsToTibble(file, transform = "asinh")
}
\arguments{
\item{file}{the fcs file containing cell infomration}

\item{transform}{if set to asinh, then asinh transforms with scale arg 5}
}
\value{
tibble of info contained within the fcs file
}
\description{
This function is a quick way to take the exprs content of
a fcs file, do an asinh transform, and create a tibble data structure
that can be further manipulated. Our default transform is asinh, but
you just have to change the transform to anything else, and you'll
get the raw data. This function is used in the main function
process.multiple.files
}
\examples{
file <- system.file("extdata", "Bendall_et_al_Cell_Sample_C_basal.fcs",
    package = "Sconify")
FcsToTibble(file)
}
