% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_ANCOM.R
\name{DA_ANCOM}
\alias{DA_ANCOM}
\title{DA_ANCOM}
\usage{
DA_ANCOM(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  fix_formula = NULL,
  adj_formula = NULL,
  rand_formula = NULL,
  lme_control = lme4::lmerControl(),
  contrast = NULL,
  alpha = 0.05,
  p_adj_method = "BH",
  struc_zero = FALSE,
  BC = TRUE,
  n_cl = 1,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{fix_formula}{Used when \code{BC = TRUE} (ANCOM-BC2). The character 
string expresses how the microbial absolute abundances for each taxon depend 
on the fixed effects in metadata.}

\item{adj_formula}{Used when \code{BC = FALSE} (ANCOM). The character string 
represents the formula for covariate adjustment. Default is NULL.}

\item{rand_formula}{Optionally used when \code{BC = TRUE} or 
\code{BC = FALSE}. The character string expresses how the microbial absolute 
abundances for each taxon depend on the random effects in metadata. 
ANCOMB and ANCOM-BC2 follows the \code{lmerTest} package in formulating the 
random effects. See \code{?lmerTest::lmer} for more details. Default is 
\code{rand_formula = NULL}.}

\item{lme_control}{a list of control parameters for mixed model fitting.
See \code{?lme4::lmerControl} for details.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{alpha}{numeric. Level of significance. Default is 0.05.}

\item{p_adj_method}{character. method to adjust p-values. Default is "holm".
Options include "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",
"fdr", "none". See \code{?stats::p.adjust} for more details.}

\item{struc_zero}{logical. Whether to detect structural zeros based on
\code{group}. Default is FALSE. See \code{Details} for
a more comprehensive discussion on structural zeros.}

\item{BC}{boolean for ANCOM method to use. If TRUE the bias correction 
(ANCOM-BC2) is computed (default \code{BC = TRUE}). When \code{BC = FALSE} 
computational time may increase and p-values are not computed.}

\item{n_cl}{numeric. The number of nodes to be forked. For details, see
\code{?parallel::makeCluster}. Default is 1 (no parallel computing).}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function. ANCOM (BC = FALSE) does not produce p-values but W statistics. 
Hence, `pValMat` matrix is filled with \code{1 - W / (nfeatures - 1)} values 
which are not p-values. To find DA features a threshold on this statistic 
can be used (liberal < 0.4, < 0.3, < 0.2, < 0.1 conservative).
}
\description{
Fast run for ANCOM and ANCOM-BC2 differential abundance detection methods.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_ANCOM(object = ps, pseudo_count = FALSE, fix_formula = "group", contrast =
   c("group", "B", "A"), verbose = FALSE)
}
\seealso{
\code{\link[ANCOMBC]{ancombc}} for analysis of microbiome 
compositions with bias correction or without it 
\code{\link[ANCOMBC]{ancom}}.
}
